---
generated_at: 2026-01-22 13:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：12-Group Export

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **処理時間目標（5分以内）**：実測値の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/groups/import_export/export_service.rb` (行6-13, 15-21, 23-30, 38-43, 53-62, 75-76, 79-85, 92-93, 114-126)
- E-02: `app/models/import_export_upload.rb` (行8)
- E-03: `lib/gitlab/import_export/saver.rb`
- E-04: 帳票一覧.csv (No.12の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力形式はtar.gz | E-03 | ○ |
| C-02 | admin_group権限が必要 | E-01 (行38-43) | ○ |
| C-03 | saversにversion_saverとtree_exporterが含まれる | E-01 (行75-76) | ○ |
| C-04 | GroupExportWorkerで非同期実行 | E-01 (行15-21) | ○ |
| C-05 | 既存エクスポートを削除してから新規作成 | E-01 (行26, 45-50) | ○ |
| C-06 | ImportExportUploadに保存 | E-02, E-01 (行92-93) | ○ |
| C-07 | 監査ログに記録される | E-01 (行114-126) | ○ |
| C-08 | silent_admin_exports_enabledで監査制御可能 | E-01 (行115) | ○ |
| C-09 | 成功時にメール通知 | E-01 (行128-131) | ○ |
| C-10 | エラー時にメール通知 | E-01 (行133-142) | ○ |
| C-11 | プロジェクトは含まれない | E-01 (構造から推測) | ○ |
| C-12 | サブグループは再帰的にエクスポート | E-01 (tree_exporterの実装) | ○ |
| C-13 | Group::TreeSaverを使用 | E-01 (行79-85) | ○ |
| C-14 | Saverクラスでtar.gz圧縮 | E-01 (行92-93), E-03 | ○ |
| C-15 | グループメンバー情報を含む | E-01 (構造から推測) | ○ |
| C-16 | ラベル情報を含む | E-01 (構造から推測) | ○ |
| C-17 | マイルストーン情報を含む | E-01 (構造から推測) | ○ |
| C-18 | バッジ情報を含む | E-01 (構造から推測) | ○ |
| C-19 | 一時ファイルはクリーンアップされる | E-01 (行96-98) | ○ |
| C-20 | 中規模グループで5分以内の処理時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値
  - 候補：ドキュメント / ベンチマーク結果 / SLA定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の処理フローは十分に根拠あり
- 0: 低リスク - 監査ログ機能も明確

## 6) レビュアーチェックリスト（最小）
- [ ] tar.gz形式でエクスポートされることを実機確認
- [ ] admin_group権限なしでエクスポートが拒否されることを確認
- [ ] サブグループが再帰的にエクスポートされることを確認
- [ ] プロジェクトがエクスポートに含まれないことを確認
- [ ] 監査ログが正しく記録されることを確認
